﻿/*!
 * Author: (Passion-Creator)
 * License: MIT License
*/

// DOMが完全に読み込まれてから処理を実行
document.addEventListener('DOMContentLoaded', function() {

    // AOS (アニメーションライブラリ) の初期化
    AOS.init({
        duration: 1000, // アニメーションが完了するまでの時間
        once: true,     // アニメーションを1度だけ実行する
    });


    // ハンバーガーメニューの処理
    const spMenuBtn = document.getElementById('sp-menu-btn');
    const spNav = document.getElementById('sp-nav');

    // spMenuBtnが存在する場合のみイベントリスナーを設定
    if (spMenuBtn) {
        spMenuBtn.addEventListener('click', () => {
            // bodyに'menu-open'クラスを付け外し
            document.body.classList.toggle('menu-open');
        });
    }

    // spNavが存在する場合のみ処理を実行
    if (spNav) {
        // ナビゲーションのリンクをクリックしたらメニューを閉じる
        const navLinks = spNav.querySelectorAll('a');
        navLinks.forEach(link => {
            link.addEventListener('click', () => {
                document.body.classList.remove('menu-open');
            });
        });
    }

});