﻿/*!
 * Author: (Passion-Creator)
 * License: MIT License
*/

// Swiper.js (ヒーロー画像スライダー) の初期化
const swiper = new Swiper('.swiper', {
  loop: true,
  effect: 'fade',
  autoplay: {
    delay: 4000,
    disableOnInteraction: false,
  },
  speed: 2000,
});

// スクロールで要素をフェードインさせる
const targets = document.querySelectorAll('.fade-in');
const observer = new IntersectionObserver((entries, observer) => {
  entries.forEach(entry => {
    if (entry.isIntersecting) {
      entry.target.classList.add('visible');
      observer.unobserve(entry.target);
    }
  });
});
targets.forEach(target => {
  observer.observe(target);
});


// ハンバーガーメニューの処理
const spMenuBtn = document.getElementById('sp-menu-btn');
const spNav = document.getElementById('sp-nav');

// ボタンをクリックした時の処理
spMenuBtn.addEventListener('click', () => {
  document.body.classList.toggle('menu-open');
});

// メニュー内のリンクをクリックした時の処理
const navLinks = spNav.querySelectorAll('a');
navLinks.forEach(link => {
  link.addEventListener('click', () => {
    document.body.classList.remove('menu-open');
  });
});